/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.analysis.FFT;
import ddf.minim.ugens.UGen;

public class Vocoder
extends UGen {
    public UGen.UGenInput audio = new UGen.UGenInput(UGen.InputType.AUDIO);
    public UGen.UGenInput modulator = new UGen.UGenInput(UGen.InputType.AUDIO);
    private int m_windowSize;
    private int m_windowSpacing;
    private float[] m_audioSamples;
    private float[] m_modulatorSamples;
    private float[] m_outputSamples;
    private int m_index;
    private int m_outputIndex;
    private int m_triggerCount;
    private float[] m_analysisSamples;
    private float m_outputScale;
    private FFT m_audioFFT;
    private FFT m_modulatorFFT;

    public Vocoder(int n, int n2) {
        float f = 1.0f;
        this.m_outputScale = 1.0f;
        if (n2 > 1) {
            f = 1.0f / (float)n2;
            this.m_outputScale = f / 8.0f;
        }
        this.m_windowSize = n;
        this.m_windowSpacing = (int)((float)n * f);
        int n3 = this.m_windowSize * 2 - this.m_windowSpacing;
        this.m_audioSamples = new float[n3];
        this.m_modulatorSamples = new float[n3];
        this.m_outputSamples = new float[n3];
        this.m_analysisSamples = new float[n];
        this.m_index = 0;
        this.m_triggerCount = this.m_windowSize;
    }

    @Override
    protected void sampleRateChanged() {
        this.m_audioFFT = new FFT(this.m_windowSize, this.sampleRate());
        this.m_modulatorFFT = new FFT(this.m_windowSize, this.sampleRate());
    }

    private void analyze(FFT fFT, float[] fArray) {
        int n = this.m_index - this.m_windowSize;
        int n2 = 0;
        while (n < this.m_index) {
            this.m_analysisSamples[n2] = n < 0 ? fArray[fArray.length + n] : fArray[n];
            ++n;
            ++n2;
        }
        fFT.forward(this.m_analysisSamples);
    }

    @Override
    protected void uGenerate(float[] fArray) {
        int n;
        this.m_audioSamples[this.m_index] = this.audio.getLastValue();
        this.m_modulatorSamples[this.m_index] = this.modulator.getLastValue();
        ++this.m_index;
        --this.m_triggerCount;
        if (this.m_index == this.m_audioSamples.length) {
            this.m_index = 0;
        }
        if (this.m_triggerCount == 0) {
            this.analyze(this.m_audioFFT, this.m_audioSamples);
            this.analyze(this.m_modulatorFFT, this.m_modulatorSamples);
            for (n = 0; n < this.m_audioFFT.specSize(); ++n) {
                this.m_audioFFT.scaleBand(n, this.m_modulatorFFT.getBand(n));
            }
            this.m_audioFFT.inverse(this.m_analysisSamples);
            FFT.HAMMING.apply(this.m_analysisSamples);
            for (n = 0; n < this.m_windowSize; ++n) {
                int n2 = this.m_outputIndex + n;
                if (n2 >= this.m_outputSamples.length) {
                    n2 -= this.m_outputSamples.length;
                }
                int n3 = n2;
                this.m_outputSamples[n3] = this.m_outputSamples[n3] + this.m_analysisSamples[n] * this.m_outputScale;
            }
            this.m_triggerCount = this.m_windowSpacing;
        }
        for (n = 0; n < fArray.length; ++n) {
            fArray[n] = this.m_outputSamples[this.m_outputIndex];
        }
        this.m_outputSamples[this.m_outputIndex] = 0.0f;
        ++this.m_outputIndex;
        if (this.m_outputIndex == this.m_outputSamples.length) {
            this.m_outputIndex = 0;
        }
    }
}

